/////////////////////////////////////////////////////////////
// CINEMA SDK : RENDERING  															   //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4DVIDEOPOSTDATA_H
#define __C4DVIDEOPOSTDATA_H

#include "c4d_nodedata.h"

class  PluginVideoPost;
class  BaseContainer;
class  BaseDocument;
class  BaseObject;
class  BaseDraw;
class  BaseDrawHelp;
class  BaseDocument;
class  BaseBitmap;
class  String;
class  CDialog;
class  Render;
struct PixelPost;
struct VideoPostStruct;

class VideoPostData : public NodeData
{
	public:
		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////

		virtual Bool Draw(PluginVideoPost *node, BaseDraw *bd, BaseDrawHelp *bh);
		virtual void AllocateBuffers(PluginVideoPost *node, Render *render, BaseDocument *doc);
		virtual LONG GetRenderInfo(PluginVideoPost *node);

		virtual LONG Execute(PluginVideoPost *node, VideoPostStruct *vps);
		virtual void ExecuteLine(PluginVideoPost *node, PixelPost *pp);
		virtual void ExecutePixel(PluginVideoPost *node, PixelPost *pp, LONG x, LONG subx, LONG suby);
};

Bool RegisterVideoPostPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, LONG disklevel, LONG priority, void *emulation=NULL);

#endif
